// Airgate TCP -- Receive-only iGate
// Relays APRS packets from RadioShield to a TCP APRS-IS server
// Copyright 2012 Markus Heller, DL8RDS
// See LICENSE.txt

#include <Arduino.h>
#include <SPI.h>
#include <Ethernet.h>

// Change callsign, network, and all other configuration in the config.h file
#include "config.h"

#define BUFFERSIZE 260
char buf[BUFFERSIZE+1];
int buflen = 0;
boolean bad_packet = false;

EthernetClient client;

void setup() {
  Serial.begin(4800);
  display("AIRGATE - DL8RDS");

#ifdef USE_DHCP
  Ethernet.begin(mac);
#else
  Ethernet.begin(mac, ip, gateway, subnet);
  delay(1000);
#endif
}

void loop() {
  // connect or reconncet to the APRS gateway
  boolean connected = check_connection();

  // As long as there are bytes in the serial queue, read them and send them out
  while (Serial.available() > 0) {
    char inbyte = Serial.read(); 
    if (inbyte == '\n') {
      // End of line: print and send packet
      buf[buflen] = 0;
      if (! bad_packet && buflen != 0) {
	if (connected) 
	  send_packet();
	display_packet();
      }
      // reset packet buffer
      buflen = 0;
      bad_packet = false;
    } else if ((inbyte < 31 && inbyte != 0x1c && inbyte != 0x1d && inbyte != 0x27)) {
      // ignore badly-decoded characters, but pass MIC-E
    } else if (! bad_packet && buflen != BUFFERSIZE) {
      // If we haven't reached end of buffer space, write it.
      buf[buflen++] = inbyte;
    } else {
      display("Data Too Long");
      // If buffer got full of characters and did not receive a EOL, there is a problem
      // so mark this packet bad and wait for the next.
      bad_packet = true;
    }
  }

  // If connected to APRS-IS, read any response from APRS-IS and display it.
  // Buffer 80 characters at a time in case printing a character at a time is slow.
  if (connected) {
    receive_data();
  }
}

// See http://www.aprs-is.net/Connecting.aspx
boolean check_connection() {
  if (!client.connected()) {
    display("Connecting...");
    if (client.connect(aprsgate, aprsport)) {
      // Log in
      client.println("user " CALLSIGN " pass " PASSCODE " vers " VERSION);
      // Send one position report
      client.println(CALLSIGN ">" DESTINATION ":!" LATITUDE "I" LONGITUDE "&" PHG "/" INFO);
      display("Connected");
    } else {
      display("Failed"); 
      // if still not connected, delay to prevent constant attempts.
      delay(1000);
    }
  }
  return client.connected();
}

void receive_data() {
  if (client.available()) {
    char rbuf[81];
    int i = 0;
    while (i < 80 && client.available()) {
      char c = client.read();
      rbuf[i++] = c;
      if (c == '\n') break;
    }
    rbuf[i] = 0;
    display(rbuf);
  }
}

void send_packet() {
  client.println(buf);
  client.println();
}

void display_packet() {
  display(buf);  
}

void display(char *msg) {
  // Put a space before each serial output line, to avoid sending commands to the RadioShield.
  Serial.print(" ");
  Serial.println(msg);
}
