// Airgate TCP / RGB / SD
// Copyright 2012 Markus Heller, DL8RDS 
// LCD and libraries by Leigh L. Klotz, Jr. WA5ZNU
// See file LICENSE.txt

#include <Arduino.h>
#include <SPI.h>
#include <Ethernet.h>

#include <Wire.h>
#include "LCD.h"
#include "colors.h"

#include <SD.h>

// Change callsign, network, and all other configuration in the config.h file
#include "config.h"

#define BUFFERSIZE 260
char buf[BUFFERSIZE+1];
int buflen = 0;
boolean bad_packet = false;

#define SD_CARD_CS 4

EthernetClient client;

void setup() {
  Serial.begin(4800);
  lcdbegin();
  display("AIRGATE - DL8RDS");

#ifdef USE_DHCP
  Ethernet.begin(mac);
#else
  Ethernet.begin(mac, ip, gateway, subnet);
  delay(1000);
#endif

  // see if the card is present and can be initialized:
  if (!SD.begin(SD_CARD_CS)) {
    lcdprint("SD Card Failed");
    return;
  }
}

void loop() {
  // connect or reconncet to the APRS gateway
  boolean connected = check_connection();

  // As long as there are bytes in the serial queue, read them and send them out
  while (Serial.available() > 0) {
    char inbyte = Serial.read(); 
    if (inbyte == '\n') {
      // End of line: 
      // send packet to APRS-IS
      buf[buflen] = 0;
      if (! bad_packet && buflen != 0) {
	if (connected) 
	  send_packet();
	// print packet to LCD
	display_packet();
	// save packet to SD Card
	save_packet();
      }
      // reset packet buffer
      buflen = 0;
      bad_packet = false;
    } else if ((inbyte < 31 && inbyte != 0x1c && inbyte != 0x1d && inbyte != 0x27)) {
      // ignore badly-decoded characters but pass MIC-E
    } else if (! bad_packet && buflen != BUFFERSIZE) {
      // If we haven't reached end of buffer space, write it.
      buf[buflen++] = inbyte;
    } else {
      display("Data Too Long");
      // If buffer got full of characters and did not receive a EOL, there is a problem
      // so mark this packet bad and wait for the next.
      bad_packet = true;
    }
  }

  // If connected to APRS-IS, read any response from APRS-IS and display it.
  // Buffer 80 characters at a time in case printing a character at a time is slow.
  if (connected) {
    receive_data();
  }
}

// See http://www.aprs-is.net/Connecting.aspx
boolean check_connection() {
  if (!client.connected()) {
    lcdcolor(RED);
    display("Connecting...");
    if (client.connect(aprsgate, aprsport)) {
      client.println("user " CALLSIGN " pass " PASSCODE " vers " VERSION);
      client.println(CALLSIGN ">" DESTINATION ":!" LATITUDE "I" LONGITUDE "&" PHG "/" INFO);
      lcdcolor(BLUE);
      display("Connected");
    } else {
      display("Failed"); 
      // if still not connected, delay to prevent constant attempts.
      delay(1000);
    }
  }
  return client.connected();
}

void receive_data() {
  if (client.available()) {
    lcdclear();
    lcdcolor(YELLOW);
    while (client.available()) {
      char c = client.read();
      if (c > 31)
	display(c);
    }
  }
}

void send_packet() {
  client.println(buf);
  client.println();
  client.println();
}

void display_packet() {
  lcdclear();
  lcdcolor(GREEN);
  display(buf);  
}

void display(char *msg) {
  lcdclear();
  lcdprint(msg);
}

void display(char c) {
  char rbuf[2];
  rbuf[0] = c;
  rbuf[1] = 0;
  lcdprint(rbuf);
}

void save_packet() {
  File file = SD.open("datalog.txt", FILE_WRITE);

  // if the file is available, write to it:
  if (file) {
    file.println(buf);
    file.close();
  } else {
    lcdcolor(RED);
    lcdprint("SD Card Failed");
  }
}
