// Airgate UDP -- Receive-only iGate
// Relays APRS packets from RadioShield to a UDP APRS-IS server
// Copyright 2012 Markus Heller, DL8RDS 
// See LICENSE.txt

#include <Arduino.h>

#include <SPI.h>
#include <Ethernet.h>
#include <EthernetUdp.h>

EthernetUDP Udp;

// Enter a MAC address and IP address for your controller below.
// The IP address will be dependent on your local network:
byte mac[] = { 0x90, 0xA2, 0xDA, 0x00, 0x75, 0xCA };

#define DHCP

#ifndef DHCP
IPAddress ip(192,168,1,145);
byte gateway[] = {192,168,1,1}; // gateway IP
byte subnet[] = { 255, 255, 255, 0 }; // netmask
#endif

byte aprsgate[] = { 173,164,210,105 }; // APRS gateway IP; here: my local computer
unsigned int localPort = 8888;	       // local originating port
int aprsport = 8080;		       // APRS gateway port

char inbyte = 0;
char buf[260];
int buflen = 0;

void setup() {
  // start the Ethernet and UDP:
#ifndef DHCP
  Ethernet.begin(mac,ip);
#else
  Ethernet.begin(mac);
#endif
  Udp.begin(localPort);
  Serial.begin(4800);
}

void loop() {
  // as long as there are bytes in the serial queue,
  // read them and send them out the socket if it's open:
  while (Serial.available() > 0) {
    inbyte = Serial.read();
    // Get the byte
    if (inbyte == '\n') {
      // Check for end of line
      buf[buflen++] = inbyte;
      buf[buflen] = 0;
      Udp.beginPacket(aprsgate, aprsport);
      Udp.write(buf);
      Udp.endPacket();
      Serial.print(" ");
      Serial.println(buf);
      buflen = 0;
      buf[buflen] = 0;
    } else if ((inbyte > 31 || inbyte == 0x1c || inbyte == 0x1d || inbyte == 0x27) && buflen < 260) {
      // Only record printable characters but pass MIC-E
      buf[buflen++] = inbyte;
      buf[buflen] = 0;
    }
  }
}
