#!/usr/bin/python

# Copyright 2012 Leigh L. Klotz, Jr. WA5ZNU Leigh@WA5ZNU.org
# MIT License: see LICENSE.txt
import socket
import select

# Configure this part with your call and APRS-IS passcode
APRS_IS_CALL="WA5ZNU-3"			# Edit this to be your call
APRS_IS_PASSCODE = "99999"		# Edit this to be your passcode

# Configure this part with your location, PHG (antenna description), and brief info
LATITUDE="3725.74N"
LONGITUDE="12206.90W"
PHG="PHG01000"
INFO="IGATE"

# You can change APRS_IS_HOST to a server geographically close to you.
# See http://www.aprs2.net/
APRS_IS_HOST="rotate.aprs2.net"
APRS_IS_PORT=14580

# Edit these if you need to change where this UDP server listens.
LISTEN_IP=""			# listen on all IP addresses this server has
LISTEN_UDP_PORT=8080		# Listen on UDP port 8080

REPLACE_PATH=False		# If true, add ",qAR,APRS_IS_CALL" to path
VERSION="wa5znu-python-aprsgate 0.1"

udp_sock = None
aprs_is_sock = None

def open_connections():
    global udp_sock, aprs_is_sock
    udp_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM) # UDP
    udp_sock.bind((LISTEN_IP, LISTEN_UDP_PORT))
    aprs_is_sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM) # TCP
    aprs_is_sock.connect((APRS_IS_HOST, APRS_IS_PORT))

def auth_packet():
    return "user %s pass %s vers %s\r\n" % (APRS_IS_CALL, APRS_IS_PASSCODE, VERSION)

def position_packet():
    return ("%s>APOTW1,TCPIP*:!%sI%s&%s/%s\r\n" % (APRS_IS_CALL, LATITUDE, LONGITUDE, PHG, INFO))

def send_packet(packet):
    global udp_sock, aprs_is_sock
    print "->", packet
    message = ("%s\r\n" % (packet))
    aprs_is_sock.sendall(message)

def process_packets():
    global udp_sock, aprs_is_sock
    # Await a read event for 5 seconds
    rlist, wlist, elist = select.select([udp_sock, aprs_is_sock], [], [], 5)
    for sock in rlist:
	if sock == udp_sock:
	    inpacket, addr = udp_sock.recvfrom(1024) # buffer size is 1024 bytes
	    inpacket = inpacket.strip()
	    if (inpacket != ""):
		send_packet(replace_path(inpacket))
	elif sock == aprs_is_sock:
	    print "<-", aprs_is_sock.recv(1024).strip()


def replace_path(packet):
    if REPLACE_PATH:
        if ":" in packet:
            (path,data) = packet.split(':', 1)
            packet = path + ",qAR," + APRS_IS_CALL + ':' + data
        else:
            print "no : in packet"
    return packet

def process():
    open_connections()
    send_packet(auth_packet())
    send_packet(position_packet())
    while True:
	process_packets()

process()
