//
// QRSS Beacon Keyer 
// 
// Copyright 2012 Hans Summers G0UPL.
//

Change the next line to your callsign followed by space and and remove this line.
const char msg[] = "N0CALL ";

const unsigned int speeds[] = {1, 2, 10, 30, 60, 100, 200, 300};
// Speeds for: 12wpm, 6wpm, QRSS1, QRSS3, QRSS6, QRSS10, QRSS20, QRSS30

#define KEY 4

//
// Function converts a character code to CW symbol encoding
//
byte charCode(char c)
{
   switch (c)
   {
     case 'A':  return B11111001;          // A  .-
     case 'B':  return B11101000;          // B  -...
     case 'C':  return B11101010;          // C  -.-.
     case 'D':  return B11110100;          // D  -..
     case 'E':  return B11111100;          // E  .
     case 'F':  return B11100010;          // F  ..-.
     case 'G':  return B11110110;          // G  --.
     case 'H':  return B11100000;          // H  ....
     case 'I':  return B11111000;          // I  ..
     case 'J':  return B11100111;          // J  .---
     case 'K':  return B11110101;          // K  -.-
     case 'L':  return B11100100;          // L  .-..
     case 'M':  return B11111011;          // M  --
     case 'N':  return B11111010;          // N  -.
     case 'O':  return B11110111;          // O  ---
     case 'P':  return B11100110;          // P  .--.
     case 'Q':  return B11101101;          // Q  --.-
     case 'R':  return B11110010;          // R  .-.
     case 'S':  return B11110000;          // S  ...
     case 'T':  return B11111101;          // T  -
     case 'U':  return B11110001;          // U  ..-
     case 'V':  return B11100001;          // V  ...-
     case 'W':  return B11110011;          // W  .--
     case 'X':  return B11101001;          // X  -..-
     case 'Y':  return B11101011;          // Y  -.--
     case 'Z':  return B11101100;          // Z  --..
     case '0':  return B11011111;          // 0  -----
     case '1':  return B11001111;          // 1  .----
     case '2':  return B11000111;          // 2  ..---
     case '3':  return B11000011;          // 3  ...--
     case '4':  return B11000001;          // 4  ....-
     case '5':  return B11000000;          // 5  .....
     case '6':  return B11010000;          // 6  -....
     case '7':  return B11011000;          // 7  --...
     case '8':  return B11011100;          // 8  ---..
     case '9':  return B11011110;          // 9  ----.
     case ' ':  return B00000000;          // Space
     case '/':  return B11010010;          // /  -..-.
     default: return charCode(' ');
   }
}

//
// Set up Pin function
// 
void setup() {                
  pinMode(KEY, OUTPUT);           // Define output pin
  pinMode(0, INPUT);              // Define pins for input of keying speed
  pinMode(1, INPUT);
  pinMode(2, INPUT);
}

//
// Arduino loop function
//
void loop()
{
  static unsigned long milliLimit;
  unsigned long milliNow;

  milliNow = millis();            // Retrieve number of milliseconds since system start

  if (milliNow >= milliLimit)     // Compare with limit
  {
    milliLimit = milliNow + 100;  // Set the next limit 0.1 seconds later
    beacon();                     // Call the beacon keyer
  }
}

// 
// Beacon keyer
//
void beacon()
{
  static unsigned int counter;       // Counter to generate the bit length, in multiples of 0.1 seconds
  static byte pause;                 // Generates inter-character pause and space
  static byte msgIndex = 255;        // Index to the message string
  static byte character;             // Current character CW symbol code
  static byte key;                   // key down counter - set to 3 for dah, 1 for dit
  static byte symbol;                // Indexes the current bit within the character CW symbol code
  static byte ditspeed;              // Index (0-7) into the ditspeed array
  
  counter++;                          // Increment the dit length counter
  if (counter == speeds[ditspeed])    // Compare with the speed setting
  {
     counter = 0;                     // reset dit length counter
 
     if (!pause)                      
     {                                
        key--;                        // if currently in key down, decrement the key down counter
                                      // When the key counter and symbol index are zero, generate and inter-character pause
 	if ((!key) && (!symbol)) pause = 2;
     }
     else
 	pause--;	              // If currently in a pause, decrement the pause counter
 
     if (key == 255)                  // When the current symbol is over, the key counter becomes 255
     {
 	if (!symbol)                  // If the symbol counter becomes zero, must now get the next character
 	{
 	   msgIndex++;                // Increment the message index
             
           if (!msg[msgIndex])        // If the string terminator (zero) is found, 
           {                          // Set the message index back to zero (the beginning of the string)
             msgIndex = 0;            // and read the dit speed setting from the pins 0-2
             ditspeed = 4 * digitalRead(2) + 2 * digitalRead(1) + digitalRead(0);
           }
                                      // Get the character symbol code for the current message string character
           character = charCode(msg[msgIndex]);
 
 	   symbol = 7;                // Set the symbol counter to the leftmost bit of the symbol code
 				      // Look for 0 signifying start of coding bits
 	   while (character & (1<<symbol))
             symbol--;
        } 			
 	
        symbol--;                     // Decrement symbol index, which moves right one bit in the symbol code

                                      // The space character is a special case, because no key downs occur
   	if (character == charCode(' '))
 	  key = 0;
 	else
 	{                             // Check the bit pointed to by the symbol index variable
 	  if (character & (1<<symbol)) 
 	    key = 3;                  // a 1 indicates a dah, and a keydown period of 3 dit-lengths
 	  else
 	    key = 1;                  // a 0 indicates a dit, and a keydown period of 1 dit-lengths
 	}
     }
 
     if (key)                         // Set the output pin
        digitalWrite(KEY, HIGH);   
     else
        digitalWrite(KEY, LOW);   
  } 
}
