; *******************************
; **** PICAXE-08M2 CW BEACON  ***
; *******************************
;    Filename: 	PICAXE-08M_BEACON_PROJECT.BAS
;    Date: 		2/15/2012			
;    File Version: 	
;    Written by: 	VK6HV, modified by K6ACJ FOR 08M2
;    Original Code at http://members.westnet.com.au/page3/picaxe-08m_mimi_28mhz_beacon.htm	
;    Function:		
;    Last Revision:	2/15/2012
;    Target PICAXE:08M2	
; ******************************* 


#Rem
*        You're more then welcome to change, add or modify!     
*                                                                    
*                                                                    
* PIN#   Project Use           PICAXE Pin Definition                 
*                                                                    
* Pin #1 +5 Volts              [+5 Volts Power]                      
* Pin #2 Serial In             [Programming]                         
* Pin #3                       [Out4/In4 Analog In4]                 
* Pin #4                       [In3]                                 
* Pin #5 cw_out                [Out2 In2 Analog In2]                 
* Pin #6                       [Out1 In1 Analog1]                    
* Pin #7 Serial Out            [Programming]                         
* Pin #8 0 Volts               [0 Volts]                             
*
*
* Speed: cwSpeed 255 fast, 130 appx 13WPM
* send call_loop_count times then wait picaxe_time and loop repeat_count 
*   
* 2/14/2012  End commands replaces stop command.
* fix names
*
*
*
#ENDREM


Init:

;Constants
Symbol string_len = 17			;Number of characters in the EEPROM command
Symbol call_loop_count = 2		;Send call twice
Symbol long_delay = 180			;delay between calling
Symbol repeat_count = 3			;Repeat string before 'end'
Symbol cw_speed = w6			;CW Speed 
		w6 = 130			;13 WPM
;W7, W8, W9 				;General purpose 16 bit registers
Symbol picaxe_time = W10

;Variables
Symbol Character = b0
Symbol Even_Or_Odd_Character = b1
Symbol Index = b2
Symbol call_loop_counter = b4		;Send loop then pause picaxe_time 
Symbol repeat_string = b6
		b6 = 1

;Ports
Symbol cw_out = Output2 		;output to 2N2222 Switch
	
;Change EEPROM to your call and beacon text 
;Change string_len to the total character count in eeprom string
;Morse Code conversion is at the end of this program.                                    

	
	EEPROM 0,(24,24,24,0,9,2,0,6,25,2,63,39,0,9,7,63,56)
	;	;Load eeprom with VVV de AXE08 DM03.string_length=17


	picaxe_time=time  	;Start picaxe Timer
	picaxe_time=picaxe_time+180	;Add 180 seconds for the next transmission
	  
Start:  
	 
	Pause 1000
	  	  
	w7 = cw_speed * 5/10 + 25     ;Dit length
	w8 = w7 * 3;dah length = Dit length X 3 
	;Character Space = Dit Length X 3 
	w9 = w7 * 5  	;Word Space = Dit length X 5
		
	For Index = 0 to string_len                                 
	  Read Index, Character                                
	  Gosub Morse
	Next
	  
	call_loop_counter = call_loop_counter + 1
	  if call_loop_counter < call_loop_count then goto start
	 
	call_loop_counter = 0		;clear at end	  
	 
	do until time > picaxe_time	;wait until present time > than past time
	  pause 500				;delay 1/2 second
	loop
	picaxe_time=time			;Load picaxe with new time
	picaxe_time=picaxe_time + long_delay	;+ 180 seconds
	  
	if repeat_string = repeat_count then end	;terminate and go to Sleep
	endif
	  
	repeat_string = repeat_string + 1
	Goto Start                          

Morse:  
                                              
	If Character = 0 then Word_sp
	Do
	Even_Or_Odd_Character = Character // 2 ;Modulus Divide returns odd/even remainder for dit or dah
	Character = Character / 2        		;Binary Shift right
	If Even_Or_Odd_Character = 0 then Gosub Dit 
	If Even_Or_Odd_Character = 1 then Gosub Dah
	Loop until Character = 1
	Gosub Char_Sp
	Return
	

	Dit:
	    High cw_out
          Pause w7         
	    Low cw_out
          Pause w7
	  Return

      Dah:
          High cw_out
          Pause w8
          Low cw_out
          Pause w7
	  Return

	Char_sp:
	    Pause w8
	    Return

	Word_sp:
          Pause w9
          Return


REM      FOR THOSE WHO DON'T KNOW MORSE CODE:)
	
REM      A .-    B -...  C -.-.  D -..    E .      F ..-.
REM      G --.   H ....  I ..    J .---   K -.-    L .-..
REM      M --    N -.    O ---   P .--.   Q --.-   R .-.
REM      S ...   T -     U ..-   V ...-   W .--    X -..-
REM      Y -.--  Z --.. 

REM      1 .---- 2 ..--- 3 ...-- 4 ....-  5 .....
REM      6 -.... 7 --... 8 ---.. 9 ----.  0 -----

REM      FULL STOP          [.]  .-.-.-     COLON                  [:]  ---...
REM      COMMA              [,]  --..--     SEMICOLON              [;]  -.-.-.
REM      QUESTION MARK      [?]  ..--..     EQUAL SIGN double dash [=]  -...-
REM      APOSTROPHE         [']  .----.     PLUS                   [+]  .-.-.
REM      EXCLAMATION MARK   [!]  -.-.--     HYPHEN minus           [-]  -....-
REM      FWD SLASH          [/]  -..-.      UNDERSCORE             [_]  ..--.-
REM      PARENTHESIS open   [(]  -.--.      QUOTATION MARK         ["]  .-..-.
REM      PARENTHESIS closed [)]  -.--.-     DOLLAR SIGN            [$]  ...-..-
REM      AMPERSAND          [&]  .-...      AT SIGN                [@]  .--.-.


REM 	   *** ENCODED CHARACTER NUMBERS ***

REM      NUMBERS USED TO PROGRAM EACH ALPHA CHARACTER INTO YOUR BEACON MESSAGE

REM      A   6,   B  17,   C  21,   D   9,   E   2,    F  20,
REM      G  11,   H  16,   I   4,   J  30,   K  13,    L  18,
REM      M   7,   N   5,   O  15,   P  22,   Q  27,    R  10,
REM      S   8,   T   3,   U  12,   V  24,   W  14,    X  25,
REM      Y  29,   Z  19, 
	   
REM      1   62,   2  60,   3  56,   4  48,   5   32,  
REM      6   33,   7  35,   8  39,   9  47,   0   63,

REM      FULL STOP          [.]  106     COLON                  [:]  71
REM      COMMA              [,]  115     SEMICOLON              [;]  85
REM      QUESTION MARK      [?]  76      EQUAL SIGN double dash [=]  49
REM      APOSTROPHE         [']  94      PLUS                   [+]  42
REM      EXCLAMATION MARK   [!]  117     HYPHEN minus           [-]  97
REM      FWD SLASH          [/]  41      UNDERSCORE             [_]  108
REM      PARENTHESIS open   [(]  45      QUOTATION MARK         ["]  82
REM      PARENTHESIS closed [)]  109     DOLLAR SIGN            [$]  200
REM      AMPERSAND          [&]  34      AT SIGN                [@]  86



'*** ALL 54 LETTERS, NUMBERS AND PUNCTUATION, FOR TESTING PURPOSES ***
'EEPROM 0, (6,17,21,9,2,20,11,16,4,30,13,18,7,5,15,22,27,10,8,3,12,24,14,25,29,19,62,60,56,48,32,33,35,39,47,63,106,115,76,94,117,41,45,109,34,71,85,49,42,97,108,82,200,86)





