; *******************************
; ***** Sunflower PV Solar Tracker *****
; *******************************
;    Filename: sunflower.bas	
;    Date: 2/13/2012			
;    File Version: 	
;    Written by: Bill Prats K6ACJ		
;    Function: Simple motor control to Track the Sun		
;    Last Revision: 2/13/2012
;    Target PICAXE:08m2	
; ******************************* 

#rem
    Sunflower PV Solar Tracker
    Copyright (C) 2012  Bill Prats

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    =====================================================================



C.0 Pin 7 to SN754410 Pin 2 Logic 1A Enable 1
C.1 Pin 6 Green LED
C.2 Pin 5 Green LED
C.4 Pin 3 to SN754410 Pin 7 Logic 2A Enable 2

Truth Table Direction SN754410
 #1  #2   #7
EN   1A   2A
H     L    H  Turn Right
H     H    L  Turn left
H     L    L  Fast motor stop
H     H    H  Fast motor stop
L     X    X  Fast motor stop


#endrem

init: 	;initialize ports and variables 

		adcsetup = %00000000000000110		
		;M2 parts, define ADC port/pin C.1 & C.2 

		let b0=0 b1=0 b2=0 b3=0 b4=0	;clarify zero out vars		
		let b10=1			;bias 
		pause 500			;

main:		
	
		;read adc
		;With bias, test A<B or B<A to set direction
		;Pulse motor into position

		gosub read_adc		;get ADC input into B0 & B1
					
		let b3=b0+b10 max 255	;variable b0 8 bit math 255 max
		let b4=b1+b10 max 255	;variable b1 8 bit math 255 max
		
		if b0 > b4 then gosub fwda
		if b1 > b3 then gosub reva
		pause 500		;motor runs 1/2 second 
		gosub all_stop		;stop motion
		pause 10000		;pause 10 seconds to eliminate jitter
 		goto main		

read_adc:
		readadc C.1,b0 		;read sensor 1
		pause 100
		readadc C.2,b1		;read sensor 2
		pause 100
		return



all_stop:					;stop all
		low c.0
		low c.4
		return

	
fwda:						;rotate
		high c.0
		low c.4
		return
		
		
reva:						;rotate the other direction
		low c.0
		high c.4
		return
		
