/*
 * APRS Recorder
 * Copyright 2011-2012 Michael Pechner NE6RD
 * Distributed under the terms of the MIT License:
 * http://www.opensource.org/licenses/mit-license
 */


#include <SD.h>
#include <string.h>
#include <LiquidCrystal.h>
#include <Wire.h>
#include "RTClib.h"
#include <SoftwareSerial.h>

//  rx  tx pin
SoftwareSerial mySerial(2, 3);

#include <stdio.h>

//Define the pin numbers
#define CS    10
#define MOSI    11
#define MISO    12
#define SCK    13
#define CHPSELECT 10
#define LINELEN 20
#define MAXLCD 80
#define LCDLINES 4

// rs en d4 d5 d6 d7
LiquidCrystal lcd(4, 5, 6, 7, 8, 9);
RTC_DS1307 RTC;
#define BUFFERSIZE	256

char inbyte = 0;        // Received byte
char buff[BUFFERSIZE];  // Incoming data buffer
//char callsign[LINELEN];      //callsign plus ssid
char printbuf[LINELEN+1];     //line to print
char timebuffer[40];
int buflen = 0;         // Length of buffered ata

void settimestamp()
{
 DateTime now = RTC.now();
 
 //1946-07-29T05:00:00-08:00
 sprintf(timebuffer, "%u-%02u-%02uT%02u:%02u:%02u-08:00", 
    now.year(), now.month(), now.day(), now.hour(), now.minute(), now.second());
  
}

void setup()                     // Runs at startup
{
  //Set up the pins for the microSD shield
  pinMode(CS, OUTPUT);
  pinMode(MOSI, OUTPUT);
  pinMode(MISO, INPUT);
  pinMode(SCK, OUTPUT);
  pinMode(CHPSELECT, OUTPUT);
  
  lcd.begin(LINELEN, 4);
  
  Serial.begin(9600);            // RadioShield runs at 4800 baud
  mySerial.begin(4800);
  delay(3);                      // Allow time for RadioShield setup
  
 // see if the card is present and can be initialized:
  if (!SD.begin(CHPSELECT)) {
    lcd.clear();
    lcd.print("Card failed, or not present");
    // don't do anything more:
    return;
  }
  
  Wire.begin();
  RTC.begin();

 if (! RTC.isrunning()) {
    Serial.println("RTC is NOT running!");
    // following line sets the RTC to the date & time this sketch was compiled
    RTC.adjust(DateTime(__DATE__, __TIME__));
  }
            // Clear screen
  lcd.clear();
  lcd.setCursor(0,0);
  delay(10);                     // Can take a bit to clear the LCD, so wait
  lcd.print("NE6RD - Waiting");    // 'Waiting' message stays until we receive something
}

void loop()                      // Runs constantly after startup
{


  while (mySerial.available() > 0) // Check for an incoming byte on the serial port
  {
    inbyte = mySerial.read();      // Get the byte
    //until we get a EOL, store just store it
    if (inbyte > 31 && buflen < BUFFERSIZE)  // Only record printable characters
    {
      buff[buflen++] = inbyte;
      buff[buflen] = ' ';
    }
    else if (inbyte == '\n') // Check for end of line
    {
      //Here we write the record to the SD card
      //Open file_handle file that's just been initialized
      File file_handle = SD.open("APRS.txt", FILE_WRITE | O_APPEND);
      if (file_handle == 0)
      {
        lcd.clear();
        lcd.setCursor(0,0);
        lcd.print("OPENFAILED");
        delay(2000);
      }
      else
      {
        settimestamp();
        file_handle.write(timebuffer);
        file_handle.write("::"); 
        file_handle.write( (const uint8_t*)buff, buflen);
        file_handle.print("\n");
        file_handle.close();
        delay(200); //Yeah, some catch up time for file operations to complete
      }
      lcd.clear();
      lcd.setCursor(0,0);
      //Serial.println("set cursor 0 0");
      //Parse the line to display in the 4x20 LCD
      //Example line to parse
      //AF6IM>APOT21:/213231h3750.14N/12137.79W^053/042/A=012814HR 165 SpO2 87  http://ParachuteMobile.org
      int ii = 0;
      int lineno = 0;
     
      while( ii < MAXLCD && ii < buflen && lineno < LCDLINES)
      {
         if ( (buflen - ii)  >= LINELEN ) 
         {
           memcpy(printbuf, buff+ii, LINELEN);
           printbuf[LINELEN] = '\0';
           ii += LINELEN;
         }
         else
         {
            memset(printbuf, ' ', LINELEN);
            printbuf[LINELEN] = '\0';
            memcpy(printbuf, buff+ii, (buflen - ii));
            ii = MAXLCD + 1;
         }
        //lcd.clear();
        lcd.setCursor(0, lineno);
        //Serial.print("set cursor "); Serial.println(lineno);
        delay(10);
        lcd.print(printbuf);
        lineno++;
        delay(100);
        
      }
       buflen = 0;
        memset(buff, BUFFERSIZE, ' ');
    }
    else if (buflen >= BUFFERSIZE)
    {
      //Assume some issue we read 256 characters and did not receive a EOL
      buflen = 0;
      memset(buff, BUFFERSIZE, ' ');
    }
    
  }  
}

