/*
 * APRS Recorder
 * Copyright 2011-2012 Michael Pechner NE6RD
 * Distributed under the terms of the MIT License:
 * http://www.opensource.org/licenses/mit-license
 */

#include <SD.h>

//Define the pin numbers
#define CS 8
#define MOSI 11
#define MISO 12
#define SCK 13
#define CHPSELECT 10

#define BUFFERSIZE 256

char inbyte = 0;		// Received byte
char buff[BUFFERSIZE];		// Incoming data buffer
char callsign[16];		//callsign plus ssid
char printline[18];		//line to print

int buflen = 0;			// Length of buffered ata

void setup()                     // Runs at startup
{
  // Set up the pins for the microSD shield
  pinMode(CS, OUTPUT);
  pinMode(MOSI, OUTPUT);
  pinMode(MISO, INPUT);
  pinMode(SCK, OUTPUT);
  pinMode(CHPSELECT, OUTPUT);
  Serial.begin(4800);            // RadioShield runs at 4800 baud
  // see if the card is present and can be initialized
  if (!SD.begin(CHPSELECT)) {
    Serial.println("Card failed, or not present");
    // don't do anything more:
    return;
  }
  
  Serial.println("B1023");        // Set display contrast
  Serial.println("C");		  // Clear screen
  delay(10);                      // Can take a bit to clear the LCD, so wait
  Serial.println("WNE6RD - Waiting");    // 'Waiting' message stays until we receive something
}

void loop() {                      // Runs constantly after startup
  while (Serial.available() > 0) { // Check for an incoming byte on the serial port
    inbyte = Serial.read();	   // Get the byte
    // until we get a EOL, store just store it
    if ((inbyte > 31 || ch == 0x1c || ch == 0x1d || ch == 0x27) && (buflen < BUFFERSIZE)) {
      // Only record printable characters, but pass MIC-E
      buff[buflen++] = inbyte;
      buff[buflen] = 0;
    } else if (inbyte == '\n') {   // Check for end of line
      // Write the record to the SD card
      // Open file_handle file that's just been initialized
      File file_handle = SD.open("APRS.txt", FILE_WRITE | O_APPEND);
      if (file_handle == 0) {
        Serial.println("WOPENFAILED");
      } else {
        file_handle.write((const uint8_t*)buff, buflen);
        file_handle.print("\n");
        file_handle.close();
      }
      // Parse the line to display in the 2x16 LCD
      // Example line to parse
      // AF6IM>APOT21:/213231h3750.14N/12137.79W^053/042/A=012814HR 165 SpO2 87  http://ParachuteMobile.org
      
      // Zero the buffers
      memset(callsign, 0, 16); 
      memset(printline,0,17);

      Serial.println("C");       // Clear screen
      delay(10);                 // Can take a bit to clear the LCD, so wait
      Serial.print("W");         // Start writting to the LCD

      int callsignLen =0;
      // Find the ">" to get the substring that contains the callsign
      callsignLen = strcspn(buff, ">"); 
      if ( callsignLen == 0 || callsignLen > 16) { //either nothing or too long
        continue; // bad aprs packet    
      } 
      strncpy(callsign, buff, callsignLen);
      strncpy(printline, buff, callsignLen);

      // skip past header data
      int pastheader = strcspn(buff+callsignLen, ":") + callsignLen;
      
      // Each line is 16 characters. Callsign is N characters, then 
      // marker is how many additional characters can be displayed on the first line
      int marker=17-callsignLen;  
      if ((buflen - pastheader) < (16-callsignLen)) //see if line less than 16 characters
        marker=buflen - pastheader;
      // fill printline with data and prit it to the LCD
      strncpy(printline+callsignLen, buff+pastheader,marker);
      Serial.println(printline);
      delay(10);
      // If no more data, we are done
      if ((buflen - pastheader + callsignLen) <= 16) {
        continue;
      }

      // Marker is now at the first character past what was written.
      marker= marker + pastheader;
      Serial.println("G1,0"); // set LCD to second line.
      delay(10);
      memset(printline, 17, 0); // zero printline
      printline[0]='W';		// "W" tells Radio Shield to write
      // ex bufflen = 25; marker = 18 
      int line_len =  buflen - marker;
      if ( line_len > 16 ) {
        line_len = 16;
      }
      strncpy(printline+1, buff+marker, line_len); // Copy from marker to the end of the line
      Serial.println(printline); // write to the LCD

      buflen = 0;
      memset(buff, BUFFERSIZE, '\0');
    } else if (buflen >= BUFFERSIZE) {
      // Assume some problem if we read 256 characters and did not receive an EOL
      buflen = 0;
      memset(buff, BUFFERSIZE, '\0');
    }
  }  
}
