#ifndef ArgentRadioShield_h
#define ArgentRadioShield_h

#include "Stream.h"

class ArgentRadioShield {
 public:
  ArgentRadioShield(Stream *stream);
  void setCall(char *call);
  void setPath(char *path);
  void sendCW(char *message);
  void sendPacket(char *message);
  void sendPacket(char *destination, char *message);
  void setVolume(byte volume);
  int available();
  int read();
  void awaitResponse(char *response);
  void setDefaultDestination(char *destination);
  void print(char *s);
  void clear();
  void setCursor(byte col, byte row);
  void setcontrast(int contrast);
  boolean decode_posit(char *packet, char **pcall, char *ptype, char **pposit, long *plon, long *plat);
 private:
  char *defaultDestination;
  Stream *stream;
  void decode_latlon(char *data, long *plat, long *plon, char *sym2);
  void decode91(char *data, long *plat, long *plon, char *sym2);
  boolean decode_mic_e(char *destination, char *posit, long *plat, long *plon);
  int miceChar(char c);
  boolean miceFlag(char c);
};

#endif
