/*
  LCDKeypad.cpp
*/

#include "Arduino.h"

// include this library's description file

#include <LiquidCrystal.h>
#include "LCDKeypad.h"

#define BACKLIGHT 10

LCDKeypad::LCDKeypad() : LiquidCrystal(8, 9, 4, 5, 6, 7)
{
  pinMode(BACKLIGHT, OUTPUT);
  backlight(255);
}

int LCDKeypad::button()
{
  static int NUM_KEYS=5;
  static int adc_key_val[5] ={  
    30, 150, 360, 535, 760     };
  int k, input;
  {
    // debounce with range 5, using idea from peterstrobl at http://www.dfrobot.com/forum/index.php?topic=31.0
    input=analogRead(0);
    delay(5);
    int delta = (analogRead(0) - input);
    if (abs(delta) > 5) return -1;
  }
  for (k = 0; k < NUM_KEYS; k++)
  {
    if (input < adc_key_val[k])
    {
      return k;
    }
  }
  if (k >= NUM_KEYS)
    k = -1;     // No valid key pressed
  return k;
}

// added backlight wa5znu at http://www.dfrobot.com/forum/index.php?topic=31.0
void LCDKeypad::backlight(byte level)
{
  analogWrite(BACKLIGHT, level/4);
}
