#include <SoftwareSerial.h>
#include <TinyGPS.h>

TinyGPS gps;
SoftwareSerial nss(4, 2);

unsigned long fix_age = 0;

char old_grid[7];
char new_grid[7];

void setup()
{
  Serial.begin(115200);
  morse("V");
  nss.begin(4800);
  delay(1000);
}

void loop() {
  if (fix_age > 60000) {
    warn_lost_fix();
    fix_age = 0;
  }

  if (readGPS()) {
    parseGPS(gps, new_grid);
    if (strcmp(old_grid, new_grid) != 0) {
      nss.end();
      note_new_grid();
      nss.begin(4800);
    }
  }
}

static void parseGPS(TinyGPS &gps, char *grid) {
  long lat, lon;
  // retrieves +/- lat/long in 100000ths of a degree
  gps.get_position(&lat, &lon, &fix_age);
  convert(lat, lon, grid);
}

static bool readGPS() {
  while (nss.available()) {
    if (gps.encode(nss.read()))
      return true;
  }
  return false;
}

void warn_lost_fix() {
  morse("IMI");
}

void note_new_grid() {
  morse(new_grid);
  strlcpy(old_grid, new_grid, sizeof(new_grid));
}
