// Adapted by Leigh WA5ZNU
// from http://www.qsl.net/5b4az/pkg/locator/gridloc/gridloc-0.6.tar.bz2
// http://www.qsl.net/5b4az/pages/utils.html
// by Neoklis Kyriazis, 5B4AZ

#define SCALE (100000L)

static void convert(long lat, long lon, char *qra) {
  // shift to positive and round up 1/2sec
  lon += 180 * SCALE + 14;
  lat +=  90 * SCALE + 14;

  {
    // Calculate first letter of field
    long rest = lon / (20 * SCALE);
    qra[0] = rest + 'A';

    // Calculate first number of square
    lon -= rest * SCALE * 20;
    rest = (lon / 2) / SCALE;
    qra[2] = rest + '0';

    // Calculate first letter of sub-square
    lon -= rest * SCALE * 2;
    rest = (lon * 12) / SCALE;
    qra[4] = rest + 'A';
  }

  {
    // Calculate second letter of field
    long rest = (lat / 10) / SCALE;
    qra[1] = rest + 'A';

    // Calculate second number of square
    lat -= (rest * 10) * SCALE;
    rest = (lat / SCALE);
    qra[3] = rest + '0';

    // Calculate second letter of sub-square
    lat -= rest * SCALE;
    rest = (lat * 24) / SCALE;
    qra[5] = rest + 'A';
  }

  qra[6] = '\0';
}
