// Morse conversion
// Based on code by Hans Summers G0UPL, 2012

// Convert a character code to CW symbol encoding

#define KEY 13
#define SPEAKER 5
#define PITCH 700
// about 12 WPM
#define SPEED (100)

static byte charCode(char c) {
   switch (c) {
   case 'A':  return B11111001;          // A  .-
   case 'B':  return B11101000;          // B  -...
   case 'C':  return B11101010;          // C  -.-.
   case 'D':  return B11110100;          // D  -..
   case 'E':  return B11111100;          // E  .
   case 'F':  return B11100010;          // F  ..-.
   case 'G':  return B11110110;          // G  --.
   case 'H':  return B11100000;          // H  ....
   case 'I':  return B11111000;          // I  ..
   case 'J':  return B11100111;          // J  .---
   case 'K':  return B11110101;          // K  -.-
   case 'L':  return B11100100;          // L  .-..
   case 'M':  return B11111011;          // M  --
   case 'N':  return B11111010;          // N  -.
   case 'O':  return B11110111;          // O  ---
   case 'P':  return B11100110;          // P  .--.
   case 'Q':  return B11101101;          // Q  --.-
   case 'R':  return B11110010;          // R  .-.
   case 'S':  return B11110000;          // S  ...
   case 'T':  return B11111101;          // T  -
   case 'U':  return B11110001;          // U  ..-
   case 'V':  return B11100001;          // V  ...-
   case 'W':  return B11110011;          // W  .--
   case 'X':  return B11101001;          // X  -..-
   case 'Y':  return B11101011;          // Y  -.--
   case 'Z':  return B11101100;          // Z  --..
   case '0':  return B11011111;          // 0  -----
   case '1':  return B11001111;          // 1  .----
   case '2':  return B11000111;          // 2  ..---
   case '3':  return B11000011;          // 3  ...--
   case '4':  return B11000001;          // 4  ....-
   case '5':  return B11000000;          // 5  .....
   case '6':  return B11010000;          // 6  -....
   case '7':  return B11011000;          // 7  --...
   case '8':  return B11011100;          // 8  ---..
   case '9':  return B11011110;          // 9  ----.
   case ' ':  return B00000000;          // Space
   case '/':  return B11010010;          // /  -..-.
   default: return charCode(' ');
   }
}

static void morse(char *msg) {
  for (byte msgIndex = 0; msg[msgIndex] != 0; msgIndex++) {
    char c = msg[msgIndex];
    byte character = charCode(c);
    // Set the symbol counter to the leftmost bit of the symbol code
    byte symbol = 7;

    // Look for 0 signifying start of coding bits
    while (character & (1<<symbol)) {
      symbol--;
    }

    if (character == charCode(' ')) {
      delay(SPEED*7);
    } else {
      while (symbol>0) {
	// Decrement symbol index, which moves right one bit in the symbol code
	symbol--;                    
	if (character & (1<<symbol)) {
	  tone(SPEAKER, PITCH);
	  delay(300);
	  noTone(SPEAKER);
	  delay(SPEED);
	} else {
	  noTone(SPEAKER);
	  tone(SPEAKER, PITCH);
	  delay(SPEED);
	  noTone(SPEAKER);
	  delay(SPEED);
	}
      }
    }
    delay(SPEED*3);
  }
}
