#include "logtable.h"
#include <Arduino.h>

#define LOG_TABLE_SIZE 25
static const prog_uchar log_key_table[LOG_TABLE_SIZE] PROGMEM = 
  {0, 2, 3, 4, 6, 7, 8, 10, 13, 16, 20, 26, 32, 40, 51, 64, 80, 100, 126, 158, 200, 251, 316, 398, 501};
static const prog_uchar log_value_table[LOG_TABLE_SIZE] PROGMEM =
  {0, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,  20,  21,  22,  23,  24,  25,  26,  27};

static uint8_t findclosest(uint8_t first, uint8_t last, int key)  {
  while (first <= last) {
    uint8_t mid = (first + last) / 2;
    uint8_t akey = pgm_read_byte(log_key_table+mid);
    if (key > akey) first = mid + 1;
    else if (key < akey) last = mid - 1;
    else return mid;
  }
  return last;
}

uint8_t db(int x) {
  return pgm_read_byte(log_value_table + findclosest(0, LOG_TABLE_SIZE, x));
}
