// Leigh L. Klotz, Jr. WA5ZNU
// This example code is in the public domain.

#include <Arduino.h>

byte speaker_pin = 8;
byte slower_pin = 2;
byte faster_pin = 3;

byte element_wait=100;

void setup() {
  pinMode(speaker_pin, OUTPUT);
  pinMode(slower_pin, INPUT_PULLUP);  // Turn on 20K pullup resistors 
  pinMode(faster_pin, INPUT_PULLUP);  // on these two pins
}

void loop() {
  send_hi_k();
}

void send_hi_k() {
  send_h();
  send_i();
  word_space();
  send_k();
  word_space();
}

void send_h() { 
  dit(); dit(); dit(); dit(); 
  letter_space();
}

void send_i() { 
  dit(); dit();
  letter_space();
}

void send_k() { 
  dah(); dit(); dah();
  letter_space();
}

void dit() {
  check_speed();
  tone(speaker_pin, 700);
  delay(element_wait);      // milliseconds
  noTone(8);
  delay(element_wait);
}

void dah() {
  check_speed();
  tone(speaker_pin, 700);
  delay(element_wait*3);
  noTone(8);
  delay(element_wait);
}

void letter_space() {
  delay(element_wait*2);
}

void word_space() {
  delay(element_wait*6);
}

void check_speed() {
  if (digitalRead(faster_pin) == LOW) {
    faster();
  }
  if (digitalRead(slower_pin) == LOW) {
    slower();
  }
}

void faster() {
  if (element_wait > 50) {
    element_wait = element_wait - 10;
  }
}

void slower() {
  if (element_wait < 200) {
    element_wait = element_wait + 10;
  }
}

