#define ORIGIN_MHZ 2400
#define HAM_BAND_WIDTH (2450-ORIGIN_MHZ)
#define WLAN1 (2412)
#define WLAN6 (2437)
#define WLAN11 (2462)
#define WLAN14 (2484)
#define WLAN_WIDTH (22)

#define CHANNEL_LEGEND_HEIGHT 11

static void drawLegend() {
  tft.setTextColor(ST7735_YELLOW);
  drawChannel(1, WLAN1-ORIGIN_MHZ, ST7735_MAGENTA);
  drawChannel(6, WLAN6-ORIGIN_MHZ, ST7735_RED);
  drawChannel(11, WLAN11-ORIGIN_MHZ, ST7735_BLUE);
  drawChannel(14, WLAN14-ORIGIN_MHZ, ST7735_BLACK);
  drawHamBand();
}

static void drawHamBand() {
  // can't draw 2300-2310 or 2390-2400 as it's outside of range.
  tft.fillRect(ORIGIN_MHZ-2400, CHANNEL_LEGEND_HEIGHT,
	       HAM_BAND_WIDTH, WATERFALL_TOP-CHANNEL_LEGEND_HEIGHT,
	       ST7735_GREEN);
  tft.setCursor(ORIGIN_MHZ-2400, CHANNEL_LEGEND_HEIGHT);
  tft.print(F("Ham Band"));
}

static void drawChannel(byte n, int x_center, int color) {
  tft.fillRect(x_center-WLAN_WIDTH/2, 0, WLAN_WIDTH, 10, color);
  tft.setCursor(x_center-5, 0);
  tft.print(n);
}
